---
obsidianUIMode: preview
---

This section offers a systematic approach for handling travel through wild lands filled with potential dangers, and can be used with both point crawls (see the previous page) or hex crawls.

As the characters travel overland, they undertake specific activities related to the journey. Select appropriate DCs for those activities, with checks usually ranging between DC 10 (easy) and DC 20 (very hard). A default of DC 12 is usually a good choice.

## Character Roles

When the characters choose to travel through the wilderness, each player chooses a role for their character to take on. If two characters feel like good choices for a particular role, one character can use the Help action to assist the other, granting advantage on the check.

### Trailhand

**Applicable Skills:** Nature, Survival

A trailhand ensures that the party follows the right path to reach an intended destination, masterfully navigating the natural or constructed paths that crisscross the wilds. With a successful check, the characters stay on the correct paths. On a failure, they might become lost, stumbling into a hostile area or losing resources. Characters might also be subject to exhaustion as they try to make their way back to the correct path, or might find it difficult to take a short or long rest until they do.

### Scout

**Applicable Skills:** Insight, Investigation, Nature, Perception, Survival

A scout keeps an eye out for potentially hostile creatures during the characters' journey. These might be creatures stalking the characters, creatures that have earlier crossed the characters' path, or creatures that are traveling in the same direction and overtake the party. With a successful check, the characters spot the potentially hostile creatures and can plan their response. On a failure, the scout might unknowingly lead the party into a hostile encounter or an ambush.

### Quartermaster

**Applicable Skills:** Medicine, Survival

A quartermaster ensures that the characters remain well fed and hydrated during their journey. They ensure that provisions remain unspoiled, and help forage for additional resources along the way. Shorter journeys might not require a character to take on this role.

With a successful check, the characters have plenty of food and water for the journey, with provisions remaining unspoiled. On a failure, the characters might lose precious resources of food and water (potentially leading to exhaustion), or need to spend additional time searching for resources.

## Group Stealth

If the characters decide to move stealthily through the wilderness, doing so doubles the length of their travel time and might impose disadvantage on other checks at your discretion. To move stealthily through the wilderness, the characters make a group Dexterity (Stealth) check and compare that result to the passive Wisdom (Perception) scores of any potentially hostile creatures that might spot or hear them.

## Creating the Wilderness

When an adventure sees the characters trekking across the wilds, use the following steps to create an adventure framework for that wilderness journey. You can use random tables to generate locations for wilderness journeys, including encounter ideas and suggestions for landmarks.

### Determine the Weather

Choose or randomly select potential weather for the characters' journey. Weather mostly adds to the in-world atmosphere, but harsh weather can change the DCs of the characters' activities as they travel if you wish.

### Determine Potential Encounters

As the characters travel through the wilderness, choose or randomly select potential encounters. These might be face-to-face encounters with denizens of the wilderness, but not all such encounters need to be hostile. The characters could run into friendly travelers, fearful monsters, weak foes, or signs of a previous battle. Likewise, they might spot the tracks of creatures recently passed by, or that are heading in the party's direction.

### Place Notable Landmarks

Use notable landmarks to mark key points along the characters' journey. Such landmarks can serve as a backdrop for random encounters or as places to rest. They might also serve as a source of secrets and clues that the characters can discover.
